// JavaScript Document
$(function() {
	// 開いているhtmlファイル名を取得
	var fileName = window.location.href.split('/').pop();
	// ファイル名から言語を特定
	var lang = fileName.split('.')[0];
	lang = lang.split('_').pop();

	var hiraganaMode = false;
	if(lang == "hiragana") {
		hiraganaMode = true;
		lang = "jp";
	}
	lang = getKey("lang");
	
	// ファイルの種類 (list* | list_doc*)
	var sort = fileName.split('.')[0];
	sort = sort.split('_')[1] == "doc" ? "doc" : "";

	// xmlからファイルの有無を確認
	$.ajax({
		url: "text_list_manual_" + lang + ".xml",
		async: false,
		cache: false,
		dataType: "xml",
		error: function(){
			alert("Error loading XML document");
		},
		success: parseXml
	});

	// 言語ごとに見出し部分を変える
	if(lang == "ko") {
		var TDs = document.getElementsByTagName("td");
		$(TDs).each(function() {
			if($(this).attr("class") == "setup") {
				$(this).text("셋업 방법");
			}else if($(this).attr("class") == "software_man") {
				$(this).text("소프트웨어 매뉴얼");
			}
		});
	}

	// XMLパース用関数
	function parseXml(xml, status){
		if(status!='success')return;
		
		$(xml).find("item").each(function() {
			// マニュアル名
			var id = $(this).attr("id");
			var name = $(this).text();
			var myDom = document.getElementById(id);
			$(myDom).find("a").text(name);
			var linkText = $(myDom).find("a").attr("href").split('/').pop();
			$(myDom).find("a").attr("href", "pdf/" + lang + "/" + linkText);
		});
	}
});

function getKey(key){
	var str = location.search.substring(1);
	if(str){
		var x = str.split("&");
		for(var i=0; i < x.length; i++) {
			var y=x[i].split("=");
			if(y[0] == key) return y[1];
		}
		return "";
	}else {
		return "";
	}
}
